<?php
/**
 * Hostxolo - Email Configuration Test
 * Test SMTP email functionality
 */
require_once 'config.php';

// Test email function
function test_smtp_email() {
    try {
        // Create PHPMailer instance
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Server settings
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USERNAME;
        $mail->Password   = SMTP_PASSWORD;
        $mail->SMTPSecure = SMTP_ENCRYPTION;
        $mail->Port       = SMTP_PORT;
        
        // Recipients
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress(SMTP_FROM_EMAIL, 'Admin Test');
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Hostxolo SMTP Test - ' . date('Y-m-d H:i:s');
        $mail->Body    = '
            <h2>SMTP Configuration Test</h2>
            <p><strong>Host:</strong> ' . SMTP_HOST . '</p>
            <p><strong>Port:</strong> ' . SMTP_PORT . '</p>
            <p><strong>Username:</strong> ' . SMTP_USERNAME . '</p>
            <p><strong>Encryption:</strong> ' . SMTP_ENCRYPTION . '</p>
            <p><strong>Test Time:</strong> ' . date('Y-m-d H:i:s') . '</p>
            <hr>
            <p>This is a test email to verify SMTP configuration is working correctly.</p>
            <p><em>Hostxolo Email System</em></p>
        ';
        $mail->AltBody = 'SMTP Test - Host: ' . SMTP_HOST . ', Port: ' . SMTP_PORT . ', Time: ' . date('Y-m-d H:i:s');
        
        // Send email
        $mail->send();
        
        return [
            'success' => true,
            'message' => 'Email sent successfully to ' . SMTP_FROM_EMAIL
        ];
        
    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => 'Email failed: ' . $e->getMessage(),
            'error' => $e->getMessage()
        ];
    }
}

// Check if PHPMailer is available
if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
    echo '<h2>PHPMailer Not Found</h2>';
    echo '<p>Please install PHPMailer using Composer:</p>';
    echo '<pre>composer require phpmailer/phpmailer</pre>';
    echo '<p>Then include the autoloader in config.php</p>';
    exit;
}

// Run test
$result = test_smtp_email();

// Display results
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMTP Test - Hostxolo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3><i class="bi bi-envelope-check me-2"></i>SMTP Configuration Test</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($result['success']): ?>
                            <div class="alert alert-success">
                                <h5><i class="bi bi-check-circle me-2"></i>Success!</h5>
                                <p><?php echo $result['message']; ?></p>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-danger">
                                <h5><i class="bi bi-x-circle me-2"></i>Test Failed</h5>
                                <p><?php echo $result['message']; ?></p>
                            </div>
                        <?php endif; ?>
                        
                        <hr>
                        
                        <h5>Current SMTP Configuration:</h5>
                        <table class="table table-striped">
                            <tr>
                                <th>Host:</th>
                                <td><?php echo htmlspecialchars(SMTP_HOST); ?></td>
                            </tr>
                            <tr>
                                <th>Port:</th>
                                <td><?php echo htmlspecialchars(SMTP_PORT); ?></td>
                            </tr>
                            <tr>
                                <th>Username:</th>
                                <td><?php echo htmlspecialchars(SMTP_USERNAME); ?></td>
                            </tr>
                            <tr>
                                <th>From Email:</th>
                                <td><?php echo htmlspecialchars(SMTP_FROM_EMAIL); ?></td>
                            </tr>
                            <tr>
                                <th>From Name:</th>
                                <td><?php echo htmlspecialchars(SMTP_FROM_NAME); ?></td>
                            </tr>
                            <tr>
                                <th>Encryption:</th>
                                <td><?php echo htmlspecialchars(SMTP_ENCRYPTION); ?></td>
                            </tr>
                        </table>
                        
                        <div class="mt-3">
                            <a href="javascript:history.back()" class="btn btn-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Go Back
                            </a>
                            <button onclick="location.reload()" class="btn btn-primary">
                                <i class="bi bi-arrow-clockwise me-2"></i>Test Again
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
