<?php
/**
 * User Panel - Header Template
 */
require_once __DIR__ . '/../../config.php';
require_login();

$user_id = $_SESSION['user_id'];

// Get user details
$user = [];
try {
    $stmt = db()->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
} catch (PDOException $e) {
    // Handle error
}

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Dashboard'; ?> - Hostxolo</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>css/style.css">
    
    <style>
        .user-sidebar {
            min-height: calc(100vh - 72px);
            background: white;
            border-right: 1px solid #e5e7eb;
        }
        .user-sidebar .nav-link {
            color: #374151;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.5rem;
        }
        .user-sidebar .nav-link:hover,
        .user-sidebar .nav-link.active {
            background: #fff7ed;
            color: #f97316;
        }
        .user-sidebar .nav-link i {
            width: 1.5rem;
        }
        .navbar-brand {
            font-weight: 800;
        }
        @media (max-width: 767.98px) {
            .user-sidebar {
                min-height: auto;
                border-right: none;
                border-bottom: 1px solid #e5e7eb;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo BASE_URL; ?>">
                <span class="text-primary">HOST</span><span class="text-dark">XOLO</span>
            </a>
            
            <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#userSidebar">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item me-3">
                        <a class="btn btn-primary btn-sm" href="<?php echo BASE_URL; ?>plans.php">
                            <i class="bi bi-plus-circle me-1"></i>Upgrade
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" data-bs-toggle="dropdown">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                <i class="bi bi-person"></i>
                            </div>
                            <span><?php echo $user['full_name'] ?? 'User'; ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>user/profile.php"><i class="bi bi-person me-2"></i>My Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>" target="_blank"><i class="bi bi-globe me-2"></i>Visit Website</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="<?php echo BASE_URL; ?>logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav id="userSidebar" class="col-md-3 col-lg-2 d-lg-block user-sidebar collapse">
                <div class="position-sticky pt-3">
                    <div class="d-flex align-items-center p-3 mb-3 d-none d-lg-flex">
                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 45px; height: 45px;">
                            <i class="bi bi-person text-primary fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 fw-bold"><?php echo $user['full_name'] ?? 'User'; ?></h6>
                            <small class="text-muted"><?php echo $user['email'] ?? ''; ?></small>
                        </div>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>" href="dashboard.php">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'subscriptions' ? 'active' : ''; ?>" href="subscriptions.php">
                                <i class="bi bi-credit-card"></i> My Subscriptions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'transactions' ? 'active' : ''; ?>" href="transactions.php">
                                <i class="bi bi-receipt"></i> Transactions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo in_array($current_page, ['tickets', 'create-ticket', 'ticket-view']) ? 'active' : ''; ?>" href="tickets.php">
                                <i class="bi bi-headset"></i> Support Tickets
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'profile' ? 'active' : ''; ?>" href="profile.php">
                                <i class="bi bi-person"></i> My Profile
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'change-password' ? 'active' : ''; ?>" href="change-password.php">
                                <i class="bi bi-shield-lock"></i> Change Password
                            </a>
                        </li>
                        <li class="nav-item mt-3">
                            <a class="nav-link text-danger" href="<?php echo BASE_URL; ?>logout.php">
                                <i class="bi bi-box-arrow-right"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="py-4">
                    <?php echo flash_message(); ?>
