<?php
/**
 * User - Invoice/Receipt View
 */
require_once __DIR__ . '/../config.php';
require_login();

$page_title = 'Invoice';
$user_id = $_SESSION['user_id'];

// Get invoice ID
$invoice_id = intval($_GET['id'] ?? 0);

if (!$invoice_id) {
    redirect(BASE_URL . 'user/subscriptions.php', 'error', 'Invalid invoice ID');
}

// Get subscription/invoice details
$invoice = null;
try {
    $stmt = db()->prepare("
        SELECT us.*, sp.name as plan_name, sp.price as plan_price, sp.duration_months,
               u.full_name, u.email, u.phone, u.company_name, u.address, u.city, u.state, u.pincode
        FROM user_subscriptions us
        JOIN subscription_plans sp ON us.plan_id = sp.id
        JOIN users u ON us.user_id = u.id
        WHERE us.id = ? AND us.user_id = ?
    ");
    $stmt->execute([$invoice_id, $user_id]);
    $invoice = $stmt->fetch();
} catch (PDOException $e) {
    error_log("Invoice fetch error: " . $e->getMessage());
}

if (!$invoice) {
    redirect(BASE_URL . 'user/subscriptions.php', 'error', 'Invoice not found');
}

// Get site settings
$site_name = get_system_setting('site_name') ?? 'Hostxolo';
$site_address = get_system_setting('contact_address') ?? '';
$site_phone = get_system_setting('contact_phone') ?? '';
$site_email = get_system_setting('contact_email') ?? '';

include __DIR__ . '/includes/header.php';
?>

<style>
.invoice-container {
    max-width: 800px;
    margin: 0 auto;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    padding: 40px;
}
.invoice-header {
    border-bottom: 2px solid #e5e7eb;
    padding-bottom: 20px;
    margin-bottom: 30px;
}
.invoice-logo {
    font-size: 1.5rem;
    font-weight: 700;
    color: #f97316;
}
.invoice-title {
    font-size: 2rem;
    font-weight: 700;
    color: #1f2937;
}
.invoice-details {
    margin-bottom: 30px;
}
.invoice-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 30px;
}
.invoice-table th,
.invoice-table td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #e5e7eb;
}
.invoice-table th {
    background: #f8fafc;
    font-weight: 600;
}
.invoice-total {
    background: #f8fafc;
    padding: 20px;
    border-radius: 8px;
    text-align: right;
}
.invoice-status {
    display: inline-block;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}
.status-paid {
    background: #d1fae5;
    color: #065f46;
}
.status-pending {
    background: #fef3c7;
    color: #92400e;
}
.status-failed {
    background: #fee2e2;
    color: #991b1b;
}
@media print {
    .no-print {
        display: none !important;
    }
    .invoice-container {
        box-shadow: none;
        padding: 0;
    }
}
</style>

<div class="d-flex justify-content-between align-items-center mb-4 no-print">
    <h2 class="fw-bold mb-0">Invoice</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer me-2"></i>Print Invoice
        </button>
        <a href="subscriptions.php" class="btn btn-outline-secondary ms-2">
            <i class="bi bi-arrow-left me-2"></i>Back
        </a>
    </div>
</div>

<div class="invoice-container">
    <!-- Invoice Header -->
    <div class="invoice-header">
        <div class="row">
            <div class="col-md-6">
                <div class="invoice-logo"><?php echo $site_name; ?></div>
                <p class="text-muted mb-0">
                    <?php if ($site_address): ?><?php echo nl2br($site_address); ?><br><?php endif; ?>
                    <?php if ($site_phone): ?><i class="bi bi-phone me-1"></i><?php echo $site_phone; ?><br><?php endif; ?>
                    <?php if ($site_email): ?><i class="bi bi-envelope me-1"></i><?php echo $site_email; ?><?php endif; ?>
                </p>
            </div>
            <div class="col-md-6 text-md-end">
                <div class="invoice-title">INVOICE</div>
                <p class="text-muted mb-0">
                    <strong>Invoice #:</strong> INV-<?php echo str_pad($invoice['id'], 6, '0', STR_PAD_LEFT); ?><br>
                    <strong>Date:</strong> <?php echo format_date($invoice['created_at']); ?><br>
                    <strong>Status:</strong> 
                    <span class="invoice-status status-<?php echo $invoice['payment_status']; ?>">
                        <?php echo ucfirst($invoice['payment_status']); ?>
                    </span>
                </p>
            </div>
        </div>
    </div>

    <!-- Billing Details -->
    <div class="invoice-details">
        <div class="row">
            <div class="col-md-6">
                <h6 class="fw-bold text-muted text-uppercase small mb-2">Billed To</h6>
                <p class="mb-0">
                    <strong><?php echo $invoice['full_name']; ?></strong><br>
                    <?php if ($invoice['company_name']): ?><?php echo $invoice['company_name']; ?><br><?php endif; ?>
                    <?php if ($invoice['email']): ?><i class="bi bi-envelope me-1"></i><?php echo $invoice['email']; ?><br><?php endif; ?>
                    <?php if ($invoice['phone']): ?><i class="bi bi-phone me-1"></i><?php echo $invoice['phone']; ?><br><?php endif; ?>
                    <?php if ($invoice['address']): ?><?php echo $invoice['address']; ?>, <?php echo $invoice['city']; ?>, <?php echo $invoice['state']; ?> - <?php echo $invoice['pincode']; ?><?php endif; ?>
                </p>
            </div>
            <div class="col-md-6 text-md-end">
                <h6 class="fw-bold text-muted text-uppercase small mb-2">Subscription Details</h6>
                <p class="mb-0">
                    <strong>Plan:</strong> <?php echo $invoice['plan_name']; ?><br>
                    <strong>Duration:</strong> <?php echo $invoice['duration_months']; ?> months<br>
                    <strong>Start Date:</strong> <?php echo format_date($invoice['start_date']); ?><br>
                    <strong>End Date:</strong> <?php echo format_date($invoice['end_date']); ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Invoice Items -->
    <table class="invoice-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Duration</th>
                <th class="text-end">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <strong><?php echo $invoice['plan_name']; ?></strong><br>
                    <small class="text-muted">Subscription Plan</small>
                </td>
                <td><?php echo $invoice['duration_months']; ?> months</td>
                <td class="text-end"><?php echo format_currency($invoice['amount_paid'] ?? $invoice['plan_price']); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Invoice Total -->
    <div class="invoice-total">
        <div class="row justify-content-end">
            <div class="col-md-4">
                <div class="d-flex justify-content-between mb-2">
                    <span>Subtotal:</span>
                    <span><?php echo format_currency($invoice['amount_paid'] ?? $invoice['plan_price']); ?></span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span>Tax:</span>
                    <span><?php echo format_currency(0); ?></span>
                </div>
                <hr>
                <div class="d-flex justify-content-between">
                    <span class="fw-bold">Total:</span>
                    <span class="fw-bold text-primary"><?php echo format_currency($invoice['amount_paid'] ?? $invoice['plan_price']); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Info -->
    <?php if ($invoice['payment_method']): ?>
    <div class="mt-4 pt-4 border-top">
        <h6 class="fw-bold text-muted text-uppercase small mb-2">Payment Information</h6>
        <p class="mb-0">
            <strong>Payment Method:</strong> <?php echo ucfirst(str_replace('_', ' ', $invoice['payment_method'])); ?><br>
            <?php if ($invoice['transaction_id']): ?>
            <strong>Transaction ID:</strong> <?php echo $invoice['transaction_id']; ?><br>
            <?php endif; ?>
            <strong>Payment Date:</strong> <?php echo format_date($invoice['created_at']); ?>
        </p>
    </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="mt-5 pt-4 border-top text-center text-muted">
        <p class="small mb-0">
            Thank you for choosing <?php echo $site_name; ?>!<br>
            For any questions regarding this invoice, please contact our support team.
        </p>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
